import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET({ params }) {
  try {
    const id = parseInt(params.id);
    const [grades] = await db.query('SELECT * FROM grades WHERE id = ?', [id]);
    
    if (grades.length === 0) {
      return json({ error: 'Nilai tidak ditemukan' }, { status: 404 });
    }
    
    return json({ success: true, data: grades[0] });
  } catch (error) {
    console.error('Get grade error:', error);
    return json({ error: 'Gagal mengambil data nilai' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function PUT({ params, request }) {
  try {
    const id = parseInt(params.id);
    const data = await request.json();
    const { studentId, studentName, subject, teacher, class: className, dailyGrade, midtermGrade, finalGrade, attitudeGrade, semester, year } = data;

    if (!studentId || !subject) {
      return json({ error: 'ID Siswa dan Mata Pelajaran wajib diisi' }, { status: 400 });
    }

    // Hitung rata-rata
    let average = null;
    if (dailyGrade !== null && dailyGrade !== undefined && midtermGrade !== null && midtermGrade !== undefined && finalGrade !== null && finalGrade !== undefined) {
      average = ((dailyGrade * 0.3) + (midtermGrade * 0.3) + (finalGrade * 0.4)).toFixed(2);
    }

    await db.query(
      `UPDATE grades 
       SET studentId = ?, studentName = ?, subject = ?, teacher = ?, class = ?, 
           dailyGrade = ?, midtermGrade = ?, finalGrade = ?, attitudeGrade = ?, 
           average = ?, semester = ?, year = ?
       WHERE id = ?`,
      [
        studentId,
        studentName || null,
        subject.trim(),
        teacher || null,
        className || null,
        dailyGrade || null,
        midtermGrade || null,
        finalGrade || null,
        attitudeGrade || null,
        average,
        semester || null,
        year || null,
        id
      ]
    );

    return json({ success: true, message: 'Nilai berhasil diupdate' });
  } catch (error) {
    console.error('Update grade error:', error);
    return json({ error: 'Gagal mengupdate nilai' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function DELETE({ params }) {
  try {
    const id = parseInt(params.id);
    await db.query('DELETE FROM grades WHERE id = ?', [id]);
    return json({ success: true, message: 'Nilai berhasil dihapus' });
  } catch (error) {
    console.error('Delete grade error:', error);
    return json({ error: 'Gagal menghapus nilai' }, { status: 500 });
  }
}
